//
//  MCButtonGrid.h
//  ButtonGridTest
//
//  Created by Ali Lalani on 6/18/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCBGButton;

@interface MCButtonGrid : NSView {
	NSMutableArray *buttons;
	
	NSDictionary *offTextAttributes;
	NSDictionary *onTextAttributes;
	NSDictionary *pressedTextAttributes;

	id target;
	SEL action;

	int numberOfColumns; // how many buttons do we lay across width-wise before we go to a new row?
	int numberOfRows;    // this is figured out dynamically based on the number of columns combined with the number of buttons

	float buttonHeight;  // set by the user
	float height;        // this is figured out dynamically based on the button height combined with the number of rows
	
	float minimumWidth;  // figured out dynamically based on number of columns and button height

	float largestTextWidth; // figured out dynamically whenever a new button is added or a title on a button is changed

	NSColor *borderColor;
}
#pragma mark Setup
- (MCBGButton *)addButtonWithTitle:(NSString *)aTitle
						   toolTip:(NSString *)aToolTip
							 image:(NSImage *)anImage
						identifier:(NSString *)anIdentifier;

// None of these are dependent on the frame or bounds
// purely dependent on number of columns, button count, button height
- (void)setupDynamicAttributes;
- (float)determineLargestTextWidth;
- (void)buttonChangedState:(MCBGButton *)aButton performAction:(BOOL)flag;
- (void)buttonChangedState:(MCBGButton *)aButton;
- (void)selectButtonWithIdentifier:(NSString *)anIdentifier;
- (MCBGButton *)buttonWithIdentifier:(NSString *)anIdentifier;
- (MCBGButton *)selectedButton;

#pragma mark Dragging
- (void)registerDragTypes:(NSArray *)anArray;
- (void)setAllowsDragSwitching:(BOOL)flag; // merely sets the bool on all buttons

#pragma mark Drawing
- (void)drawHorizontalDividerForButton:(MCBGButton *)button atIndex:(unsigned int)i column:(unsigned int)column row:(unsigned int)row;
- (void)drawVerticalDividerForButton:(MCBGButton *)button atIndex:(unsigned int)i column:(unsigned int)column;
- (void)drawCornerForButton:(MCBGButton *)button atIndex:(unsigned int)i column:(unsigned int)column row:(unsigned int)row;
- (void)drawEmptyAreaInRect:(NSRect)emptyRect;
- (void)tile;

#pragma mark Accessors
- (NSMutableArray *)buttons;

- (id)target;
- (void)setTarget:(id)aTarget;
- (SEL)action;
- (void)setAction:(SEL)anAction;
- (int)numberOfColumns;
- (void)setNumberOfColumns:(int)aNumberOfColumns;
- (float)buttonHeight;
- (void)setButtonHeight:(float)aButtonHeight;
- (float)height;
- (float)minimumWidth;
- (NSDictionary *)offTextAttributes;

// Text attributes
- (void)setOffTextAttributes:(NSDictionary *)anOffTextAttributes;
- (NSDictionary *)onTextAttributes;
- (void)setOnTextAttributes:(NSDictionary *)anOnTextAttributes;
- (NSDictionary *)pressedTextAttributes;
- (void)setPressedTextAttributes:(NSDictionary *)aPressedTextAttributes;
@end
